<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class ThrottleByUsername
{
    public function handle($request, Closure $next)
    {
        // Cek apakah metode pembayaran adalah "SALDO"
        if ($request->payment_method == 'SALDO') {
            $username = Auth::user()->username;

            // Cache key untuk menyimpan waktu terakhir user melakukan order
            $cacheKey = 'last_order_time_' . $username;
            $lastOrderTime = Cache::get($cacheKey);

            if ($lastOrderTime) {
                $diffInMinutes = now()->diffInMinutes($lastOrderTime);

                if ($diffInMinutes < 1) {
                    return response()->json(['status' => false, 'data' => 'Anda hanya dapat melakukan pemesanan satu kali setiap menit.']);
                }
            }

            // Update cache dengan waktu sekarang
            Cache::put($cacheKey, now(), 60);
        }

        return $next($request);
    }
}
